<?php
/**
 * DokuWiki Plugin image (Syntax Component)
 *
 * @license GPL 2 http://www.gnu.org/licenses/gpl-2.0.html
 * @author  SC YOO <dryoo@live.com>
 */

// must be run within Dokuwiki
if (!defined('DOKU_INC')) die();

if (!defined('DOKU_LF')) define('DOKU_LF', "\n");
if (!defined('DOKU_TAB')) define('DOKU_TAB', "\t");
if (!defined('DOKU_PLUGIN')) define('DOKU_PLUGIN',DOKU_INC.'lib/plugins/');

require_once DOKU_PLUGIN.'syntax.php';

class syntax_plugin_image_show extends DokuWiki_Syntax_Plugin {
    public function getType() {
        return 'substition';
    }

    public function getPType() {
        return 'normal';
    }

    public function getSort() {
        return 301;
    }


    public function connectTo($mode) {
        $this->Lexer->addSpecialPattern('\{\{image>[^}]*\}\}',$mode,'plugin_image_show');
//        $this->Lexer->addEntryPattern('<FIXME>',$mode,'plugin_image_show');
    }

//    public function postConnect() {
//        $this->Lexer->addExitPattern('</FIXME>','plugin_image_show');
//    }

    public function handle($match, $state, $pos, &$handler){
        $data = array();
        $match = substr($match,8,-2); //strip markup from start and end

        // alignment
        $data['align'] = 0;
        if(substr($match,0,1) == ' ') $data['align'] += 1;
        if(substr($match,-1,1) == ' ') $data['align'] += 2;

        $data['src']=$match;
        $data['class']='media ';
        return $data;
    }

    public function render($mode, &$renderer, $data) {
        if($mode != 'xhtml') return false;
        switch ($data['align']){
            case 1:
            $data['class'].="medialeft";break;
            case 2:
            $data['class'].="mediaright";break;
            case 3:
            $data['class'].="mediacenter";break;
        }
       $renderer->doc.= '<a href="'.$data['src'].'" rel="lightbox"><img src="'.$data['src'].'" class="'.$data['class'].'"></a>';

        return true;
    }
}

// vim:ts=4:sw=4:et:
